/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.summoningrituals.recipe.component;

import com.almostreliable.summoningrituals.util.Bruhtils;
import com.almostreliable.summoningrituals.util.SerializeUtils;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public final class BlockReference
implements Predicate<BlockState> {
    private final Block block;
    private final Map<String, String> properties;
    private final Map<Integer, Boolean> testCache;
    @Nullable
    private BlockState displayState;

    private BlockReference(Block block, Map<String, String> properties) {
        this.block = block;
        this.properties = properties;
        this.testCache = new HashMap<Integer, Boolean>();
    }

    public static BlockReference fromJson(JsonObject json) {
        ResourceLocation blockId = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"block"));
        Block block = SerializeUtils.blockFromId(blockId);
        Map<String, String> properties = new HashMap<String, String>();
        if (json.has("properties")) {
            properties = SerializeUtils.mapFromJson(json.getAsJsonObject("properties"));
        }
        return new BlockReference(block, properties);
    }

    public static BlockReference fromNetwork(FriendlyByteBuf buffer) {
        ResourceLocation blockId = buffer.m_130281_();
        Block block = SerializeUtils.blockFromId(blockId);
        Map<String, String> properties = SerializeUtils.mapFromNetwork(buffer);
        return new BlockReference(block, properties);
    }

    public JsonElement toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("block", Bruhtils.getId(this.block).toString());
        if (!this.properties.isEmpty()) {
            json.add("properties", (JsonElement)SerializeUtils.mapToJson(this.properties));
        }
        return json;
    }

    public void toNetwork(FriendlyByteBuf buffer) {
        buffer.m_130085_(Bruhtils.getId(this.block));
        SerializeUtils.mapToNetwork(buffer, this.properties);
    }

    @Override
    public boolean test(BlockState blockState) {
        Boolean cached = this.testCache.get(Block.m_49956_((BlockState)blockState));
        if (cached != null) {
            return cached;
        }
        if (!this.block.equals(blockState.m_60734_())) {
            this.testCache.put(Block.m_49956_((BlockState)blockState), false);
            return false;
        }
        ImmutableMap toCompareProps = blockState.m_61148_();
        for (Map.Entry<String, String> prop : this.properties.entrySet()) {
            if (!toCompareProps.entrySet().stream().noneMatch(entry -> ((Property)entry.getKey()).m_61708_().equalsIgnoreCase((String)prop.getKey()) && ((Comparable)entry.getValue()).toString().equalsIgnoreCase((String)prop.getValue()))) continue;
            this.testCache.put(Block.m_49956_((BlockState)blockState), false);
            return false;
        }
        this.testCache.put(Block.m_49956_((BlockState)blockState), true);
        return true;
    }

    public BlockState getDisplayState() {
        if (this.displayState != null) {
            return this.displayState;
        }
        AtomicReference<BlockState> newState = new AtomicReference<BlockState>(this.block.m_49966_());
        for (Property property : newState.get().m_61147_()) {
            String newValue = this.properties.get(property.m_61708_());
            if (newValue == null) continue;
            try {
                newState.set((BlockState)newState.get().m_61124_(property, (Comparable)Bruhtils.cast(newValue)));
            }
            catch (Exception ignored) {
                property.m_6215_(newValue.toString()).ifPresent(v -> newState.set((BlockState)((BlockState)newState.get()).m_61124_(property, (Comparable)Bruhtils.cast(v))));
            }
        }
        this.displayState = newState.get();
        return this.displayState;
    }
}

